function test_suite = testHorzcat %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
y = horzcat(polysym.empty);
assertTrue(isempty(y))

function testDefault
y = horzcat(polysym);
assertEqual(y,polysym)

function testRowVector
polysyms('x','y','z')
w =  horzcat(x,y,z);
assertEqual(w,polysym({'x','y','z'}))

function testColumns
polysyms one two three four five six
w = horzcat([one; two; three],[four; five; six]);
assertEqual(w,polysym({'one', 'four'; 'two', 'five'; 'three', 'six'}))

function testPartlyEmpty
e = polysym.empty;
one = polysym('1');
two = polysym('2');
v = horzcat(e,one,two);
assertEqual(v,polysym([[] 1 2]))

function testPartlyEmptyMultipleRows
e = polysym.empty;
one = polysym('1');
two = polysym('2');
v = [e, one; one; e; e, two];
assertEqual(v,polysym([[],1; 1, []; [], 2]))

function testMixedClass
p1 = polysym('x'); p2 = 'y';
v = horzcat(p1,p2);
assertEqual(v,polysym({'x','y'}))
